//
//  AHKProgressWindowController.h
//  AH-K3001V Address Utility
//
//  Created by FUJIDANA on Thu Apr 14 2005.
//  Copyright 2005 FUJIDANA. All rights reserved.
//
//
//  ProgressController.h
//  BookmarkUtility
//
//  Created by raktajino on Sat Jun 26 2004.
//  Copyright (c) 2004 raktajino. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import <Cocoa/Cocoa.h>
#import "AHKProgressing.h"

@protocol AHKProgressing;

@interface AHKProgressWindowController : NSWindowController <AHKProgressing> {
	IBOutlet NSProgressIndicator	*progressIndicator;
	IBOutlet NSTextField			*messageTextField;
	IBOutlet NSTextField			*countTextField;
	
	NSWindow		*parentWindow;
	
	NSModalSession	session;
//	BOOL			isOpen; // <- unnesessary. Substituted by checking whether "session" is null or not.
//	BOOL			isExceptionRaised;
	BOOL			isRequestedToAbort;
}

// if window is null, progress window will be displayed as an independent modal window; else as a sheet of the window.

+ (id)sharedWindowControllerWithParentWindow:(NSWindow *)window; // weak reference (not retain) to parent window
- (id)initWithParentWindow:(NSWindow *)window;

- (IBAction)requestToAbortProgress:(id)sender;

@end
